within Modelica_LinearSystems2.Controller.Examples;
model DoublePendulum
  extends Modelica.Icons.Example;

  extends Templates.SimpleStateSpaceControl(
    redeclare Components.DoublePendulum2 plant(
      additionalMeasurableOutputs=true,
      m_trolley=5,
      m_load=20,
      length=2,
      n=6,
      l=6,
      phi1_start=-0.69813170079773,
      phi2_start=-0.34906585039887),
    preFilter(
      matrixName="M_pa",
      fileName=Modelica_LinearSystems2.DataDir + "doublePendulumController.mat",
      matrixOnFile=true),
    feedbackMatrix(
      matrixOnFile=true,
      matrixName="K_pa",
      fileName=Modelica_LinearSystems2.DataDir + "doublePendulumController.mat"),
    sampleClock(sampleTime=0.01, blockType=Modelica_LinearSystems2.Controller.Types.BlockType.Discrete));

  annotation (
    Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-120,-100},{120,
            100}}), graphics),
    experiment(
      StopTime=40,
      NumberOfIntervals=2000,
      Tolerance=1e-005),
    experimentSetupOutput,
    Commands,
    Documentation(info="<html>
 
This example shows a control system with constant state feedback.
The system model of a crane trolles system is taken from [1]. The
feedback matrix and the pre filter can be loaded from MATLAB files. By default, this files 
are generated by call of Modelica_LinearSystems2.Examples.StateSpace.craneController.<br>
<p>
 
<A name=\"References\"><B><FONT SIZE=\"+1\">References</FONT></B></A>
<PRE>
  [1] Fllinger, O. \"Regelungstechnik\", Hthig-Verlag
</PRE>
</html>"),
    Icon(coordinateSystem(preserveAspectRatio=true, extent={{-120,-100},{120,
            100}})));
  Modelica.Blocks.Sources.Pulse pulse(
    offset=0,
    amplitude=3,
    width=50,
    startTime=5,
    period=10) 
              annotation (Placement(transformation(extent={{-120,-10},{-100,10}})));
  FirstOrder firstOrder(T=0.25) 
    annotation (Placement(transformation(extent={{-90,-5},{-80,5}})));
equation
  connect(firstOrder.u, pulse.y) annotation (Line(
      points={{-91,0},{-99,0}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(firstOrder.y, preFilter.u[1]) annotation (Line(
      points={{-79.5,0},{-62,0}},
      color={0,0,127},
      smooth=Smooth.None));
end DoublePendulum;
